/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.item;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.inventory.InventoryPersonalStorage;
import mekanism.common.inventory.container.item.MekanismItemContainer;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.registries.MekanismContainerTypes;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class PersonalStorageItemContainer
extends MekanismItemContainer {
    private InventoryPersonalStorage itemInventory;

    public PersonalStorageItemContainer(int id, Inventory inv, InteractionHand hand, ItemStack stack) {
        super(MekanismContainerTypes.PERSONAL_STORAGE_ITEM, id, inv, hand, stack);
    }

    @Override
    protected void addSlotsAndOpen() {
        this.itemInventory = new InventoryPersonalStorage(this.stack);
        super.addSlotsAndOpen();
    }

    @Override
    protected void addSlots() {
        super.addSlots();
        List<IInventorySlot> inventorySlots = this.itemInventory.getInventorySlots(null);
        for (IInventorySlot inventorySlot : inventorySlots) {
            Slot containerSlot = inventorySlot.createContainerSlot();
            if (containerSlot == null) continue;
            this.m_38897_(containerSlot);
        }
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    @Override
    protected int getInventoryYOffset() {
        return 140;
    }

    @Override
    protected HotBarSlot createHotBarSlot(@Nonnull Inventory inv, int index, int x, int y) {
        if (index == inv.f_35977_ && this.hand == InteractionHand.MAIN_HAND) {
            return new HotBarSlot((Container)inv, index, x, y){

                public boolean m_8010_(@Nonnull Player player) {
                    return false;
                }
            };
        }
        return super.createHotBarSlot(inv, index, x, y);
    }

    public void m_150399_(int slotId, int dragType, @Nonnull ClickType clickType, @Nonnull Player player) {
        if (clickType == ClickType.SWAP) {
            if (this.hand == InteractionHand.OFF_HAND && dragType == 40) {
                return;
            }
            if (this.hand == InteractionHand.MAIN_HAND && dragType >= 0 && dragType < Inventory.m_36059_() && !((HotBarSlot)this.hotBarSlots.get(dragType)).m_8010_(player)) {
                return;
            }
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }
}

